package com.avaya.ccs.javafxrefclient;

import java.util.Arrays;
import java.util.List;
import javax.swing.event.ChangeEvent;
import com.avaya.ccs.core.ContactListItem;
import com.avaya.ccs.core.CustomerData;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class ContactSearchTab {
//	private static final Logger LOG = Logger.getLogger(ContactSearchTab.class);
	
	private final Tab tab;
	private InteractionDataGUI gui;
	private InteractionExecutor interactionExe;
	
	private ObservableList<ContactListItem> searchResults = FXCollections.observableArrayList(); 
	private ListView<ContactListItem> searchResultsListView = new ListView<>(); 
	
	/**
	 * TODO conroy1 add Contact Search in a future release
	 * 
	 * @param interactionExe
	 * @param gui
	 */
	public ContactSearchTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
		tab = new Tab();
        tab.setText("Contact Search");
        tab.setClosable(false);
        this.gui=gui;
        this.interactionExe=interactionExe;
        
        VBox root = new VBox(5);
        Label searchCriteriaLabel= new Label("Search Criteria");
        
        
        ObservableList<String> subject = FXCollections.observableArrayList();
        subject.addAll(Arrays.asList(
        		"Skillset", 
        		"Status", 
        		"Subject",
        		"ClosedReason",
        		"Type",
        		"DispositionCode",
        		"MailTo",
        		"MailFrom",
        		"ArrivalDate",
        		"LastAction",
        		"Agent",
        		"ID",
        		"ClosedDate"
        		));
        ComboBox<String> subjectCB= new ComboBox<String>(subject);
        
		//Operators:
		//	"Is", 			//skillset, status, ClosedReason, Type, DispCode, LastAction, Agent
		//	"IsNot", 		//skillset, status, ClosedReason, Type, DispCode, LastAction, Agent
	    //
        //	"Contains", 	//subject, MailTo, MailFrom
		//	"BeginsWith", 	//subject, MailTo, MailFrom
		//	"EndsWith",  	//subject, MailTo, MailFrom
		//
	    //	"Before", 		//ArrivalDate, ClosedDate
		//	"On", 			//ArrivalDate, ClosedDate
		//	"After", 		//ArrivalDate, ClosedDate
	    //
	    //	"LessThan", 	//ID
		//	"EqualTo", 		//ID
		//	"GreaterThan" 	//ID
		
        
        String[] operators1 = new String[] {"Is","IsNot"};
        String[] operators2 = new String[] {"Contains","BeginsWith","EndsWith"};
        String[] operators3 = new String[] {"Before","On","After"};
        String[] operators4 = new String[] {"LessThan","EqualTo","GreaterThan"};
        
        ObservableList<String> operators = FXCollections.observableArrayList();
        operators.addAll(Arrays.asList());
        	
        ComboBox<String> operatorsCB= new ComboBox<String>(operators);
        
        ObservableList<String> values = FXCollections.observableArrayList();
        values.addAll(Arrays.asList());
        ComboBox<String> valuesCb= new ComboBox<String>(values);
        
        TextField valuesTf= new TextField();
        DatePicker valuesDp= new DatePicker();
        
        HBox searchCriteriaHbox= new HBox(5);
        Button  addQueryButton = new Button("+");
        searchCriteriaHbox.getChildren().addAll(subjectCB, operatorsCB, valuesCb,addQueryButton );
        
		HBox buttonsHbox = new HBox(5);
        Button searchBtn = new Button("Search");
        
        buttonsHbox.getChildren().addAll(searchBtn);
        
		subjectCB.setOnAction((event) -> {
			//the operators and values could all be populated in one complicated switch statement. 
			//but for developer clarity, we'll do it in three passes
			
			//populate operators
			switch(subjectCB.getValue()){
			case "Skillset":
			case "Status":
			case "ClosedReason":
			case "Type":
			case "DispositionCode":
			case "LastAction":
			case "Agent":
				operators.clear();
				operators.addAll(Arrays.asList(operators1));
				break;
			case "Subject":
			case "MailTo":
			case "MailFrom":
				operators.clear();
				operators.addAll(Arrays.asList(operators2));
				break;
			case "ArrivalDate":
			case "ClosedDate":
				operators.clear();
				operators.addAll(Arrays.asList(operators3));
				break;
			case "ID":
				operators.clear();
				operators.addAll(Arrays.asList(operators4));
				break;
			default:
				operators.clear();
				break;
			}
			
			
			//set the Value control. Sometimes the value control has to be a TextField; 
			//		other times a ComboBox, other times a DatePicker
			switch(subjectCB.getValue()){
			case "Subject":
			case "MailTo":
			case "MailFrom":			
			case "ID":
				//make the Value control a textbox, remove other controls
				valuesTf.clear();
				if (searchCriteriaHbox.getChildren().contains(valuesCb))
					searchCriteriaHbox.getChildren().remove(valuesCb);
				if (searchCriteriaHbox.getChildren().contains(valuesDp))
					searchCriteriaHbox.getChildren().remove(valuesDp);
				if (!searchCriteriaHbox.getChildren().contains(valuesTf))
					searchCriteriaHbox.getChildren().add(2,valuesTf);
				break;
			case "Skillset":
			case "Status":
			case "ClosedReason":
			case "Type":
			case "DispositionCode":
			case "LastAction":
			case "Agent":
				//make the Value control a Combobox; and populate it accordingly. remove other controls
				if (searchCriteriaHbox.getChildren().contains(valuesTf))
					searchCriteriaHbox.getChildren().remove(valuesTf);
				if (searchCriteriaHbox.getChildren().contains(valuesDp))
					searchCriteriaHbox.getChildren().remove(valuesDp);
				if (!searchCriteriaHbox.getChildren().contains(valuesCb))
					searchCriteriaHbox.getChildren().add(2,valuesCb);
				break;
			case "ArrivalDate":
			case "ClosedDate":
				//make the Value control a DatePicker, remove other controls
				if (searchCriteriaHbox.getChildren().contains(valuesTf))
					searchCriteriaHbox.getChildren().remove(valuesTf);
				if (searchCriteriaHbox.getChildren().contains(valuesCb))
					searchCriteriaHbox.getChildren().remove(valuesCb);
				if (!searchCriteriaHbox.getChildren().contains(valuesDp))
					searchCriteriaHbox.getChildren().add(2,valuesDp);
				break;
			}

		
			//where the Value is a comboBox, populate it with the correct items
			switch(subjectCB.getValue()){
			case "Skillset":
				values.clear();
				values.addAll(getSkillsets());
				break;
			case "Status":
				values.clear();
				values.addAll(getStatuses());
				break;
			case "ClosedReason":
				values.clear();
				values.addAll(getClosedReasons());
				break;
			case "Type":
				values.clear();
				values.addAll(getTypes());
				break;
			case "DispositionCode":
				values.clear();
				values.addAll(getDispositionCodes());
				break;
			case "LastAction":
				values.clear();
				values.addAll(getLastActions());
				break;
			case "Agent":
				values.clear();
				values.addAll(getAgents());
				
			break;
			}		
		});
		
		
		searchBtn.setOnAction((ActionEvent t)->{
        	
        	String key= subjectCB.getValue();
        	String condition = operatorsCB.getValue();
        	String value="";

        	//getting the value depends on what type of control contains it
        	if (searchCriteriaHbox.getChildren().contains(valuesCb))
        		value=valuesCb.getValue();
        	else if (searchCriteriaHbox.getChildren().contains(valuesTf))
        		value=valuesTf.getText();
        	else if (searchCriteriaHbox.getChildren().contains(valuesDp))
        		value=valuesDp.getValue().toString();
        	this.interactionExe.searchContacts("{\"SearchCriteriaList\":[{\"Key\":\""+key+"\",\"Condition\":\""+condition+"\",\"Value\":\"" + value +"\"}]}");
        });
		
		searchResultsListView.setItems(searchResults);
		
		root.getChildren().addAll(searchCriteriaLabel,searchCriteriaHbox, buttonsHbox, searchResultsListView);
        tab.setContent(root);
        tab.setDisable(false);
        
	}

	

	private String[] getAgents() {
		// TODO Auto-generated method stub
		return new String[] {};
	}

	private String[] getLastActions() {
		return new String[] {"Agent Created","Outgoing Call","Replied","Rescheduled","Transferred","Unknown"};
	}

	private String[] getDispositionCodes() {
		// TODO Auto-generated method stub
		return new String[] {};
	}

	private String[] getTypes() {
		return new String[] {"Email", "WebChat"};
	}

	private String[] getClosedReasons() {
		// TODO Auto-generated method stub
		return new String[] {};
	}

	private String[] getStatuses() {
		return new String[] {"Closed","New","Open","Waiting"};
	}

	private String[] getSkillsets() {
		// TODO Auto-generated method stub
		return new String[] {};
	}
	
	public void setSearchResults(CustomerData c){
		//TODO implement
	}
	
	public Tab getTab() {		
		return tab;
	}

}


